using System;
using System.Collections.Generic;
using System.Text;

namespace PI.ZB.N1200.ELearning.BL
{
    public static class Dictionary
    {
        public const string PLUGIN_NAME = "PI.ZB.1200.ELearning.BL";
        public const string WinFormsName = "PI.ZB.1200.ELearning.WinForms";

        /// <summary>
        /// Klienty
        /// </summary>
        public static class Clients
        {
            internal static int BASE_CLIENT_ID = Gemini.Core.BL.Base.BusinessLogicPlugIn.GetBaseClientID("1200");

            public static int PlugIn = BASE_CLIENT_ID + 1;
        }

        public static class Params
        {
            public const string StudentUserTypeID = "StudentUserTypeID";
            public const string StudentUserPasswordFormat = "StudentUserPasswordFormat";
            public const string InstructorUserTypeID = "InstructorUserTypeID";
            public const string InstructorUserPasswordFormat = "InstructorUserPasswordFormat";

            public static class RemindEmail
            {
                public const string Server = "RemindEmailServer";
                public const string User = "RemindEmailUser";
                public const string Password = "RemindEmailPassword";
                public const string FromEmail = "RemindEmailFromEmail";
                public const string FromName = "RemindEmailFromName";
                public const string Subject = "RemindEmailSubject";
            }

            public static class CreateAccountEmail
            {
                public const string Server = "CreateAccountEmailServer";
                public const string User = "CreateAccountEmailUser";
                public const string Password = "CreateAccountEmailPassword";
                public const string FromEmail = "CreateAccountEmailFromEmail";
                public const string FromName = "CreateAccountEmailFromName";
                public const string Subject = "CreateAccountEmailSubject";
            }

            public static class ClearStatsEmail
            {
                public const string Subject = "ClearStatsEmailSubject";
                public const string ToEmail = "ClearStatsEmailToEmail";
            }

            public static class APIEduFarma
            {
                public const string ServiceURL = "APIServiceURL"; // http://91.121.9.108/edufarma/api/
                public const string SecretKey = "APISecretKey"; // edufarma.secret.key.839102!@#45%
                public const string User = "APIUser"; // edufarma
                public const string Version = "APIVersion"; //0.1
            }

            public const string KnowledgeTestQuestionsNumber = "KnowledgeTest Questions Number";
        }

        /// <summary>
        /// Obiekty do praw
        /// </summary>
        public static class Objects
        {
            public static class UI
            {
                public static int SchoolList = 101;
                public static int CompetenceList = 102;
                public static int CompetenceEdit = 109;

                public static int CompetencePartList = 110;
                public static int CompetencePartEdit = 111;

                public static int InstructorList = 103;
                public static int ClassList = 104;
                public static int StudentList = 105;
                public static int AdvancedLevelList = 107;
                public static int EvaluationSheetList = 108;

                public static int Config = 120;
                public static int ExerciseAvatar = 121;
                public static int SchoolYear = 122;
            }
        }

        public static class Category
        {
            public enum DifficultyType
            {
                A   = 1,
                B   = 2,
                C   = 3,
                Instructor = 4
            }

            public enum CourseType
            {
                KnowledgeTest = 1,
                AdvancedTest = 2,
                CompetenceCourse = 3,
                CompetenceTheory = 4,
                Case = 5
            }

            public static class CourseTypeText
            {
                public const string KnowledgeTest       = "Test wiedzy";
                public const string AdvancedTest        = "Test umiejtnoci";
                public const string CompetenceCourse    = "Nauka kompetencji";
                public const string CompetenceTheory    = "Teoria kompetencji";
                public const string Case                = "Case";                
            }
        }

        public static class Text
        {
            public static class Grid
            {
                /// <summary>
                /// Kompetencja gwna
                /// </summary>
                public static Gemini.Core.BL.Base.Translation Competence = new Gemini.Core.BL.Base.Translation(PLUGIN_NAME, "Grid_Competence", "Kompetencja gwna", "POL");

                /// <summary>
                /// Kompletna
                /// </summary>
                public static Gemini.Core.BL.Base.Translation IsValid = new Gemini.Core.BL.Base.Translation(PLUGIN_NAME, "Grid_IsValid", "Kompletna", "POL");

                /// <summary>
                /// Typ wiczenia
                /// </summary>
                public static Gemini.Core.BL.Base.Translation ExerciseType = new Gemini.Core.BL.Base.Translation(PLUGIN_NAME, "Grid_ExerciseType", "Typ wiczenia", "POL");

                /// <summary>
                /// Zdarzenie
                /// </summary>
                public static Gemini.Core.BL.Base.Translation ExerciseEvent = new Gemini.Core.BL.Base.Translation(PLUGIN_NAME, "Grid_ExerciseEvent", "Zdarzenie", "POL");


                public static class SchoolYear
                {
                    /// <summary>
                    /// Rok szkolny
                    /// </summary>
                    public static Gemini.Core.BL.Base.Translation Name = new Gemini.Core.BL.Base.Translation(PLUGIN_NAME, "Grid_SchoolYear_Name", "Rok szkolny", "POL");

                    /// <summary>
                    /// Biecy
                    /// </summary>
                    public static Gemini.Core.BL.Base.Translation IsActive = new Gemini.Core.BL.Base.Translation(PLUGIN_NAME, "Grid_SchoolYear_IsActive", "Biecy", "POL");

                    /// <summary>
                    /// Zamknity
                    /// </summary>
                    public static Gemini.Core.BL.Base.Translation IsClosed = new Gemini.Core.BL.Base.Translation(PLUGIN_NAME, "Grid_SchoolYear_IsClosed", "Zamknity", "POL");
                }

                public static class School
                {
                    /// <summary>
                    /// Miasto
                    /// </summary>
                    public static Gemini.Core.BL.Base.Translation Town = new Gemini.Core.BL.Base.Translation(PLUGIN_NAME, "Grid_School_Town", "Miast", "POL");

                    /// <summary>
                    /// Nazwa
                    /// </summary>
                    public static Gemini.Core.BL.Base.Translation Name = new Gemini.Core.BL.Base.Translation(PLUGIN_NAME, "Grid_School_Name", "Nazwa", "POL");

                    /// <summary>
                    /// Szkoa
                    /// </summary>
                    public static Gemini.Core.BL.Base.Translation SchoolName = new Gemini.Core.BL.Base.Translation(PLUGIN_NAME, "Grid_School_SchoolName", "Szkoa", "POL");

                }

                public static class EvaluationSheet
                {
                    /// <summary>
                    /// Od %
                    /// </summary>
                    public static Gemini.Core.BL.Base.Translation From = new Gemini.Core.BL.Base.Translation(PLUGIN_NAME, "Grid_EvaluationSheet_From", "Od %", "POL");

                    /// <summary>
                    /// Do %
                    /// </summary>
                    public static Gemini.Core.BL.Base.Translation To = new Gemini.Core.BL.Base.Translation(PLUGIN_NAME, "Grid_EvaluationSheet_To", "Do %", "POL");

                    /// <summary>
                    /// Stanowisko
                    /// </summary>
                    public static Gemini.Core.BL.Base.Translation Name = new Gemini.Core.BL.Base.Translation(PLUGIN_NAME, "Grid_EvaluationSheet_Name", "Stanowisko", "POL");

                    /// <summary>
                    /// Pensja
                    /// </summary>
                    public static Gemini.Core.BL.Base.Translation Salary = new Gemini.Core.BL.Base.Translation(PLUGIN_NAME, "Grid_EvaluationSheet_Salary", "Pensja", "POL");
                }
            }

            public static class Group
            {
                public static Gemini.Core.BL.Base.Translation Instructor = new Gemini.Core.BL.Base.Translation(PLUGIN_NAME, "Group_Instructor"  , "Instruktor", "POL");
                public static Gemini.Core.BL.Base.Translation Teacher = new Gemini.Core.BL.Base.Translation(PLUGIN_NAME, "Group_Teacher"        , "Nauczyciel", "POL");
                public static Gemini.Core.BL.Base.Translation Student = new Gemini.Core.BL.Base.Translation(PLUGIN_NAME, "Group_Student"        , "Ucze", "POL");
            }

            /// <summary>
            /// Czy jeste pewnien aktualizacji planu nauczania? Istniej podpite statystyki dla tego planu. Jeeli zapiszesz zmiany, wwczas statystyki zostan utracone bezpowrotnie.
            /// </summary>
            public static Gemini.Core.BL.Base.Translation QuestionUpdateTeachingPlan = new Gemini.Core.BL.Base.Translation(PLUGIN_NAME, "QuestionUpdateTeachingPlan", "Czy jeste pewnien aktualizacji planu nauczania? Istniej podpite statystyki dla tego planu. Jeeli zapiszesz zmiany, wwczas statystyki zostan utracone bezpowrotnie.", "POL");

            /// <summary>
            /// Nie mona usun szkoy. Istniej klasy zdefiniowane dla tej szkoy.
            /// </summary>
            public static Gemini.Core.BL.Base.Translation Error_SchoolRemove_ExistsClass = new Gemini.Core.BL.Base.Translation(PLUGIN_NAME, "Error_SchoolRemove_ExistsClass", "Nie mona usun szkoy. Istniej klasy zdefiniowane dla tej szkoy.", "POL");

            /// <summary>
            /// Nie mona usun szkoy. Istniej klasy zdefiniowane dla tej szkoy.
            /// </summary>
            public static Gemini.Core.BL.Base.Translation Error_SchoolRemove_ExistsInstructor = new Gemini.Core.BL.Base.Translation(PLUGIN_NAME, "Error_SchoolRemove_ExistsInstructor", "Nie mona usun szkoy. Istniej klasy zdefiniowane dla tej szkoy.", "POL");

            /// <summary>
            /// Nie mona usun klasy, poniewa istniej przypisani do tej klasy pracownicy.
            /// </summary>
            public static Gemini.Core.BL.Base.Translation Error_ClassRemove_ExistsStudent = new Gemini.Core.BL.Base.Translation(PLUGIN_NAME, "Error_ClassRemove_ExistsStudent", "Nie mona usun klasy, poniewa istniej przypisani do tej klasy pracownicy.", "POL");

            /// <summary>
            /// Prba niezautoryzowanego dostepu
            /// </summary>
            public static Gemini.Core.BL.Base.Translation Error_AjaxInstructor_LoginNotAutorized = new Gemini.Core.BL.Base.Translation(PLUGIN_NAME, "Error_AjaxInstructor_LoginNotAutorized", "Prba niezautoryzowanego dostepu.", "POL");

            /// <summary>
            /// Brak parametru InstructorID
            /// </summary>
            public static Gemini.Core.BL.Base.Translation Error_AjaxInstructor_MissingInstructorID = new Gemini.Core.BL.Base.Translation(PLUGIN_NAME, "Error_AjaxInstructor_MissingInstructorID", "Brak parametru InstructorID.", "POL");

            /// <summary>
            /// Nie mona odczyta danych Kadrowca dla ID {0}
            /// </summary>
            public static Gemini.Core.BL.Base.Translation Error_AjaxInstructor_CannotRead = new Gemini.Core.BL.Base.Translation(PLUGIN_NAME, "Error_AjaxInstructor_CannotRead", "Nie mona odczyta danych Kadrowca dla ID {0}.", "POL");

            /// <summary>
            /// Prba niezautoryzownego dostpu. Zalogowany uytkownik nie jest Kadrowcem.
            /// </summary>
            public static Gemini.Core.BL.Base.Translation Error_AjaxInstructor_UserNotInstructor = new Gemini.Core.BL.Base.Translation(PLUGIN_NAME, "Error_AjaxInstructor_UserNotInstructor", "Prba niezautoryzownego dostpu. Zalogowany uytkownik nie jest Kadrowcem.", "POL");

            /// <summary>
            /// Prba niezautoryzowanego dostepu.
            /// </summary>
            public static Gemini.Core.BL.Base.Translation Error_AjaxStudent_LoginNotAutorized = new Gemini.Core.BL.Base.Translation(PLUGIN_NAME, "Error_AjaxStudent_LoginNotAutorized", "Prba niezautoryzowanego dostepu.", "POL");

            /// <summary>
            /// Brak parametru StudentID
            /// </summary>
            public static Gemini.Core.BL.Base.Translation Error_AjaxStudent_MissingStudentID = new Gemini.Core.BL.Base.Translation(PLUGIN_NAME, "Error_AjaxStudent_MissingStudentID", "Brak parametru StudentID.", "POL");

            /// <summary>
            /// Nie mona odczyta danych Pracownika dla ID {0}.
            /// </summary>
            public static Gemini.Core.BL.Base.Translation Error_AjaxStudent_CannotRead = new Gemini.Core.BL.Base.Translation(PLUGIN_NAME, "Error_AjaxStudent_CannotRead", "Nie mona odczyta danych Pracownika dla ID {0}.", "POL");

            /// <summary>
            /// Prba niezautoryzownego dostpu. Zalogowany uytkownik nie jest Pracownikiem.
            /// </summary>
            public static Gemini.Core.BL.Base.Translation Error_AjaxStudent_UserNotStudent = new Gemini.Core.BL.Base.Translation(PLUGIN_NAME, "Error_AjaxStudent_UserNotStudent", "Prba niezautoryzownego dostpu. Zalogowany uytkownik nie jest Pracownikiem.", "POL");

            public static class Competence
            {
                /// <summary>
                /// Kompetencja gwna <b>{0}</b> posiada przyporzdkowane kompetencje skadowe. Usunicie spowoduje rwnie skasowanie kompetencji skadowych i potencjaln utrat spjnoci danych. Czy na pewno usun?
                /// </summary>
                public static Gemini.Core.BL.Base.Translation ConfirmRemoveConnectedWithCompetenceParts = new Gemini.Core.BL.Base.Translation(PLUGIN_NAME, "Competence_ConfirmRemoveConnectedWithCompetenceParts", "Kompetencja gwna <b>{0}</b> posiada przyporzdkowane kompetencje skadowe. Usunicie spowoduje rwnie skasowanie kompetencji skadowych i potencjaln utrat spjnoci danych. Czy na pewno usun?", "POL");

                /// <summary>
                /// Czy na pewno usun kompetencje gwna <b>{0}</b>?
                /// </summary>
                public static Gemini.Core.BL.Base.Translation ConfirmRemove = new Gemini.Core.BL.Base.Translation(PLUGIN_NAME, "Competence_ConfirmRemove", "Czy na pewno usun kompetencje gwna <b>{0}</b>?", "POL");
            
            }

            public static class CompetencePart
            {
                /// <summary>
                /// Kompetencja skadowa <b>{0}</b> posiada przyporzdkowane kursy. Usunicie spowoduje skasowanie statystyk kursw i utrat spjnoci danych. Czy na pewno usun?
                /// </summary>
                public static Gemini.Core.BL.Base.Translation ConfirmRemoveConnectedWithCompetenceParts = new Gemini.Core.BL.Base.Translation(PLUGIN_NAME, "CompetencePart_ConfirmRemoveConnectedWithCompetenceParts", "Kompetencja skadowa <b>{0}</b> posiada przyporzdkowane kursy. Usunicie spowoduje skasowanie statystyk kursw i utrat spjnoci danych. Czy na pewno usun?", "POL");

                /// <summary>
                /// Czy na pewno usun kompetencje skadow <b>{0}</b>?
                /// </summary>
                public static Gemini.Core.BL.Base.Translation ConfirmRemove = new Gemini.Core.BL.Base.Translation(PLUGIN_NAME, "CompetencePart_ConfirmRemove", "Czy na pewno usun kompetencje skadow <b>{0}</b>?", "POL");

            }

            public static class Panel
            {
                /// <summary>
                /// Kompetencja gwna {0}
                /// </summary>
                public static Gemini.Core.BL.Base.Translation Competence = new Gemini.Core.BL.Base.Translation(PLUGIN_NAME, "Panel_Competence", "Kompetencja gwna {0}", "POL");

                /// <summary>
                /// Kompetencja skadowa {0}
                /// </summary>
                public static Gemini.Core.BL.Base.Translation CompetencePart = new Gemini.Core.BL.Base.Translation(PLUGIN_NAME, "Panel_CompetencePart", "Kompetencja skadowa {0}", "POL");
            }

            public static class SchoolYear
            {
                /// <summary>
                /// Usunicie roku szkolnego <b>{0}</b> spowoduje trwae usunicie klas i uczniw wraz ze statystykami przyporzdkowanych do tego roku.<br>Prosz potwierdzi operacj hasem.
                /// </summary>
                public static Gemini.Core.BL.Base.Translation Confirm_Delete = new Gemini.Core.BL.Base.Translation(PLUGIN_NAME, "SchoolYear_Conform_Delete", "Usunicie roku szkolnego <b>{0}</b> spowoduje trwae usunicie klas i uczniw wraz ze statystykami przyporzdkowanych do tego roku.<br>Prosz potwierdzi operacj hasem.", "POL");

                /// <summary>
                /// Nie mona usun aktywnego roku szkolnego.
                /// </summary>
                public static Gemini.Core.BL.Base.Translation DeleteForbidden = new Gemini.Core.BL.Base.Translation(PLUGIN_NAME, "SchoolYear_DeleteForbidden", "Nie mona usun biecego roku szkolnego.", "POL");

                /// <summary>
                /// Zamknicie roku szkolnego <b>{0}</b> spowoduje zagregowanie statystyk uczniw oraz zablokowanie kont.<br>Prosz potwierdzi operacj hasem.
                /// </summary>
                public static Gemini.Core.BL.Base.Translation Confirm_Close = new Gemini.Core.BL.Base.Translation(PLUGIN_NAME, "SchoolYear_Conform_Close", "Zamknicie roku szkolnego <b>{0}</b> spowoduje zagregowanie statystyk uczniw oraz zablokowanie ich kont.<br>Prosz potwierdzi operacj hasem.", "POL");

                /// <summary>
                /// Zamykanie roku szkolnego {0}
                /// </summary>
                public static Gemini.Core.BL.Base.Translation DoClose = new Gemini.Core.BL.Base.Translation(PLUGIN_NAME, "SchoolYear_Conform_DoClose", "Zamykanie roku szkolnego {0}", "POL");

            }

            public static class Student
            {
                /// <summary>
                /// Indeks dziennika nr <b>{0}</b> jest ju przydzielony do ucznia {1} {2}.
                /// </summary>
                public static Gemini.Core.BL.Base.Translation IndexAlreadyExist = new Gemini.Core.BL.Base.Translation(PLUGIN_NAME, "Student_IndexAlreadyExist", "Indeks dziennika nr <b>{0}</b> jest ju przydzielony do ucznia {1}.", "POL");

                /// <summary>
                /// Nie powiodo si zaoenie konta dla ucznia. Wystpi problem z weryfikacj podanego konta email {0}.
                /// </summary>
                public static Gemini.Core.BL.Base.Translation CreateFailedCauseEmail = new Gemini.Core.BL.Base.Translation(PLUGIN_NAME, "Student_CreateFailedCauseEmail", "Nie powiodo si zaoenie konta dla ucznia. Wystpi problem z weryfikacj podanego konta email <b>{0}</b>.", "POL");
           
                /// <summary>
                /// Nie mona zmieni hasa ucznia. Haso zostao bdnie wprowadzone.
                /// </summary>
                public static Gemini.Core.BL.Base.Translation PasswordChangeFailed = new Gemini.Core.BL.Base.Translation(PLUGIN_NAME, "Student_PasswordChangeFailed", "Nie mona zmieni hasa ucznia. Haso zostao bdnie wprowadzone.", "POL");

                /// <summary>
                /// Nie udao si zapisa danych ucznia {0}.
                /// </summary>
                public static Gemini.Core.BL.Base.Translation SaveFailed = new Gemini.Core.BL.Base.Translation(PLUGIN_NAME, "Student_SaveFailed", "Nie udao si zapisa danych ucznia <b>{0}</b>.", "POL");                            
            }

            public static class Class
            {
                /// <summary>
                /// Nie udao si zapisa danych klasy {0}.
                /// </summary>
                public static Gemini.Core.BL.Base.Translation SaveFailed = new Gemini.Core.BL.Base.Translation(PLUGIN_NAME, "Class_SaveFailed", "Nie udao si zapisa danych klasy <b>{0}</b>.", "POL");

                /// <summary>
                /// Nie udao si usunc danych klasy {0}.
                /// </summary>
                public static Gemini.Core.BL.Base.Translation RemoveFailed = new Gemini.Core.BL.Base.Translation(PLUGIN_NAME, "Class_RemoveFailed", "Nie udao si usun danych klasy <b>{0}</b>.", "POL");

                /// <summary>
                /// Klasa o nazwie <b>{0}</b> jest ju zarejestrowana dla biecego roku szkolnego.
                /// </summary>
                public static Gemini.Core.BL.Base.Translation NameAlreadyExist = new Gemini.Core.BL.Base.Translation(PLUGIN_NAME, "Class_NameAlreadyExist", "Klasa o nazwie <b>{0}</b> jest ju zarejestrowana dla biecego roku szkolnego.", "POL");
            }

            public static class School
            {
                /// <summary>
                /// Nie mona usun szkoy <b>{0}</b> gdy istniej klasy zdefiniowane dla niej.
                /// </summary>
                public static Gemini.Core.BL.Base.Translation RemoveFailedClassExist = new Gemini.Core.BL.Base.Translation(PLUGIN_NAME, "School_RemoveFailedClassExist", "Nie mona usun szkoy <b>{0}</b> gdy istniej klasy zdefiniowane dla niej.", "POL");

                /// <summary>
                /// Usunicie szkoy <b>{0}</b> spowoduje trwae usunicie klas, nauczycieli i uczniw wraz ze statystykami przyporzdkowanych do tej szkoy.<br>Prosz potwierdzi operacj hasem.
                /// </summary>
                public static Gemini.Core.BL.Base.Translation Confirm_Delete = new Gemini.Core.BL.Base.Translation(PLUGIN_NAME, "School_Conform_Delete", "Usunicie szkoy <b>{0}</b> spowoduje trwae usunicie klas, nauczycieli i uczniw wraz ze statystykami przyporzdkowanych do tej szkoy.<br>Prosz potwierdzi operacj hasem.", "POL");            
            }

            public static class Instructor
            {
                /// <summary>
                /// Nie mona usun konta nauczyciela <b>{0}</b> gdy nadal posiada on przyporzdkowane klasy.
                /// </summary>
                public static Gemini.Core.BL.Base.Translation RemoveFailes_ExistsClass = new Gemini.Core.BL.Base.Translation(PLUGIN_NAME, "Instructor_RemoveFailes_ExistsClass", "Nie mona usun konta nauczyciela <b>{0}</b> gdy nadal posiada on przyporzdkowane klasy.", "POL");

                /// <summary>
                /// Nie udao si zapisa danych nauczyciela <b>{0}</b>.
                /// </summary>
                public static Gemini.Core.BL.Base.Translation SaveFailed = new Gemini.Core.BL.Base.Translation(PLUGIN_NAME, "Instructor_SaveFailed", "Nie udao si zapisa danych nauczyciela <b>{0}</b>.", "POL");

                /// <summary>
                /// Nie powiodo si zaoenie konta dla nauczyciela. Wystpi problem z weryfikacj podanego konta email {0}.
                /// </summary>
                public static Gemini.Core.BL.Base.Translation CreateFailedCauseEmail = new Gemini.Core.BL.Base.Translation(PLUGIN_NAME, "Instructor_CreateFailedCauseEmail", " Nie powiodo si zaoenie konta dla nauczyciela. Wystpi problem z weryfikacj podanego konta email <b>{0}</b>.", "POL");

                /// <summary>
                /// Usunicie nauczyciela <b>{0} {1}</b> spowoduje trwae usunicie klas i uczniw wraz ze statystykami przyporzdkowanych do tego nauczyciela.<br>Prosz potwierdzi operacj hasem.
                /// </summary>
                public static Gemini.Core.BL.Base.Translation Confirm_Delete = new Gemini.Core.BL.Base.Translation(PLUGIN_NAME, "Instructor_Conform_Delete", "Usunicie nauczyciela <b>{0} {1}</b> spowoduje trwae usunicie klas i uczniw wraz ze statystykami przyporzdkowanych do tego nauczyciela.<br>Prosz potwierdzi operacj hasem.", "POL");            

            }
        }

        /// <summary>
        /// Nazwy grup 
        /// </summary>
        public enum GroupType
        {
            /// <summary>
            /// Nauczyciele
            /// </summary>
            Instructor = 1,

            /// <summary>
            /// Uczniowie
            /// </summary>
            Student = 2,

            /// <summary>
            /// Autorzy merytoryczni
            /// </summary>
            Supervisor = 3,
        }

        public static class Config
        {
            public static class Tests
            {
                public static class StartKnowledgeTest
                {
                    public static string CourseID           = "StartKnowledgeTest_CourseID";
                    public static string ImageID            = "StartKnowledgeTest_ImageID";
                    public static string ImageURL           = "StartKnowledgeTest_ImageURL";
                    public static string Abbreviaton        = "StartKnowledgeTest_Abbreviaton";
                    public static string RandomizePercent   = "StartKnowledgeTest_RandomizePercent";
                    public static long ContextObjectID = 3;
                }

                public static class EndKnowledgeTest
                {
                    public static long ContextObjectID = 4;
                    public static string CourseID           = "EndKnowledgeTest_CourseID";
                    public static string ImageID            = "EndKnowledgeTest_ImageID";
                    public static string ImageURL           = "EndKnowledgeTest_ImageURL";
                    public static string Abbreviaton        = "EndKnowledgeTest_Abbreviaton";
                    public static string RandomizePercent   = "EndKnowledgeTest_RandomizePercent";
                }

                public static class StartAdvancedTest
                {
                    public static long   ContextObjectID = 1;
                    public static string CourseID       = "StartAdvancedTest_CourseID";
                    public static string ImageID        = "StartAdvancedTest_ImageID";
                    public static string ImageURL       = "StartAdvancedTest_ImageURL";
                    public static string Abbreviaton    = "StartAdvancedTest_Abbreviaton";
                }

                public static class EndAdvancedTest
                {
                    public static long ContextObjectID = 2;
                    public static string CourseID       = "EndAdvancedTest_CourseID";
                    public static string ImageID        = "EndAdvancedTest_ImageID";
                    public static string ImageURL       = "EndAdvancedTest_ImageURL";
                    public static string Abbreviaton    = "EndAdvancedTest_Abbreviaton";
                }
            }

            public static class eduFarma
            {
                public static string GameAddress    = "eduFarma_Address";
                public static string AdminAddress   = "eduFarma_AdminAddress";
                public static string ImageID        = "eduFarma_ImageID";
                public static string ImageURL       = "eduFarma_ImageURL";
            }

            public static class Avatar
            {
                public static string Width = "Avatar_Width";

                public static class Load
                {
                    public static string Text = "Avatar_Load_Text";
                    public static string ImageID = "Avatar_Load_ImageID";
                    public static string ImageURL = "Avatar_Load_ImageURL";
                }

                public static class Check 
                {
                    public static string Text = "Avatar_Check_Text";
                    public static string ImageID = "Avatar_Check_ImageID";
                    public static string ImageURL = "Avatar_Check_ImageURL";
                }

                public static class Resolve
                {
                    public static string Text = "Avatar_Resolve_Text";
                    public static string ImageID = "Avatar_Resolve_ImageID";
                    public static string ImageURL = "Avatar_Resolve_ImageURL";
                }
            }

            public static class AdditionalConfig
            {
                public static string MainPortalAddress = "additionalConfig_MainPortalAddress";
            }
        }

        public static class XMLNodes
        {
            public static string Avatar = "AVATAR";
        }

        public static class Avatar
        {
            public static string User = "@Uczen";
            public static string Point = "@Punkty";
            public static string MaxPoint = "@PunktyMax";
        }

        public enum AuxyliaryPagesType
        {
            None = 0,
            CourseMenu = -1,
            Summary = -2,
            NoAccess = -3,
            Error = -4,
            Fraud = -5,
            StartSummary = -6,
            Redirect = -7,
            NoExercises = -8
        }
    }
}
